<?php
function travivu_register_meta_boxes(){
	$prefix = 'travivu_';
	global $meta_boxes;
	$meta_boxes = array();

	/* ====== Metabox Template ====== */
	$meta_boxes[] = array(
		'id'    => 'gavias_metaboxes_page',
		'title' => esc_html__('Page Meta', 'travivu'),
		'pages' => array( 'gva__template'),
		'priority'   => 'high',
		'fields' => array(
			array(
				'name' => esc_html__('Template Type', 'travivu'),
				'id'   => "gva_template_type",
				'type' => 'text'
			),
		)
	);

	/* ====== Metabox Page ====== */
	$meta_boxes[] = array(
		'id'    => 'gavias_metaboxes_page',
		'title' => esc_html__('Page Meta', 'travivu'),
		'pages' => array( 'page'),
		'priority'   => 'high',
		'fields' => array(
			array(
            'name' => esc_html__('Full Width', 'travivu'),
            'id'   => "{$prefix}page_full_width",
            'type' => 'switch',
            'desc' => esc_html__('Turn on to have the main area display at 100% width according to the window size. Turn off to follow site width.', 'travivu'),
            'std' => 0,
         ),
			array(
				'name' => esc_html__('Header Layout', 'travivu'),
				'id'   => "{$prefix}header_layout",
				'type' => 'select',
				'options' => travivu_list_header_layout(),
				'multiple' => false,
				'std'  => '_default_active',
			),
			array(
				'name' => esc_html__('Footer Layout', 'travivu'),
				'id'   => "{$prefix}footer_layout",
				'type' => 'select',
				'options' => travivu_list_footer_layout(),
				'multiple' => false,
				'std'  => '_default_active',
			),
			array(
				'name' => esc_html__('Extra page class', 'travivu'),
				'id' => $prefix . 'extra_page_class',
				'desc' => esc_html__("If you wish to add extra classes to the body class of the page (for custom css use), then please add the class(es) here.", 'travivu'),
				'clone' => false,
				'type'  => 'text',
				'std' => '',
			),
		)
	);

	/* ====== Metabox Page Title ====== */
	$meta_boxes[] = array(
		'id' => 'gavias_metaboxes_page_heading',
		'title' => esc_html__('Page Title & Breadcrumb', 'travivu'),
		'pages' => array( 'post', 'page', 'product', 'portfolio', 'tribe_events'),
		'context' => 'normal',
		'priority'   => 'high',
		'fields' => array(
		  	array(
				'name' => esc_html__('Remove Title of Page', 'travivu'),   
				'id'   => "{$prefix}disable_page_title",
				'type' => 'switch',
				'std'  => 0,
		  	),
		  	array(
			 	'name' => esc_html__('Disable Breadcrumbs', 'travivu'),
			 	'id'   => "{$prefix}no_breadcrumbs",
			 	'type' => 'switch',
			 	'desc' => esc_html__('Disable the breadcrumbs from under the page title on this page.', 'travivu'),
			 	'std' => 0,
		  	),
		  	array(
			 	'name' => esc_html__('Breadcrumb Layout', 'travivu'),
			 	'id'   => "{$prefix}breadcrumb_layout",
			 	'type' => 'select',
			 	'options' => array(
				 	'layout_options'    => esc_html__('Default Options in Layout Template', 'travivu'),
				 	'page_options'      => esc_html__('Individuals Options This Page', 'travivu')
			 	),
			 	'multiple' => false,
			 	'std'  => 'theme_options',
			 	'desc' => esc_html__('You can use breadcrumb settings default in Layout Template or individuals this page', 'travivu')
		  	),
		  	array(
			 	'name' 	=> esc_html__( 'Background Overlay Color', 'travivu' ),
			 	'id'   	=> "{$prefix}breacrumb_bg_color",
			 	'desc' 	=> esc_html__( "Set an overlay color for hero heading image.", 'travivu' ),
			 	'type' 	=> 'color',
			 	'class' => 'breadcrumb_setting',
			 	'std'  	=> '',
		  	),
		  	array(
			 	'name'       => esc_html__( 'Overlay Opacity', 'travivu' ),
			 	'id'         => "{$prefix}breacrumb_bg_opacity",
			 	'desc'       => esc_html__( 'Set the opacity level of the overlay. This will lighten or darken the image depening on the color selected.', 'travivu' ),
			 	'clone'      => false,
			 	'type'       => 'slider',
			 	'prefix'     => '',
			 	'class'   	  => 'breadcrumb_setting',
			 	'js_options' => array(
				  	'min'  => 0,
				  	'max'  => 100,
				  	'step' => 1,
			 	),
			 	'std'   => '50'
		  	),
		  	array(
			 	'name'  	=> esc_html__('Breadcrumb Background Image', 'travivu'),
			 	'id'    	=> "{$prefix}breacrumb_image",
			 	'type'  	=> 'image_advanced',
			 	'class'   	=> 'breadcrumb_setting',
			 	'max_file_uploads' => 1
		  	),
		)
	);

	/* ====== Metabox Trip ====== */
	$meta_boxes[] = array(
		'id'    => 'gavias_metaboxes_trip',
		'title' => esc_html__('Trip Meta', 'travivu'),
		'pages' => array( 'trip'),
		'priority'   => 'high',
		'fields' => array(
			array(
				'name' => esc_html__('Banner Layout', 'travivu'),
				'id'   => "{$prefix}banner_layout",
				'type' => 'select',
				'options' => array(
					'_default_' => esc_html__('- Default Global Setting -', 'travivu'),
					'banner-default' => esc_html__('Banner Layout Default', 'travivu'),
					'banner-layout-1' => esc_html__('Banner Layout 01', 'travivu'),
					'banner-layout-2' => esc_html__('Banner Layout 02', 'travivu'),
					'banner-layout-3' => esc_html__('Banner Layout 03', 'travivu'),
					'banner-layout-4' => esc_html__('Banner Layout 04', 'travivu'),
					'banner-layout-5' => esc_html__('Banner Layout 05', 'travivu'),
					'banner-layout-6' => esc_html__('Banner Layout 06', 'travivu')
				),
				'multiple' => false,
				'std'  => '_default_',
			)
		)
	);

	return $meta_boxes;
 }  
  /********************* META BOX REGISTERING ***********************/
  add_filter( 'rwmb_meta_boxes', 'travivu_register_meta_boxes' , 99 );

